using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using gov.va.med.vbecs.Common;
using ClassBrRules = gov.va.med.vbecs.Common.VbecsBrokenRules.InappropriateTransfusionRequestReport;

namespace gov.va.med.vbecs.BOL
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/28/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides collection of input parameters and data retrieval for the inappropriate transfusion request report.</summary>

	#endregion

	public class InappropriateTransfusionRequestReport : VbecsReport
	{
        private DataSet _dsReport = new DataSet();
		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5844"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>Non-null object.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5849"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>No rules are broken.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5845"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Initializes the object, sets broken rules.
		/// </summary>
		public InappropriateTransfusionRequestReport()
			: base() 
		{
			SetInitialBrokenRules( ClassBrRules.FormClassName, ClassBrRules.RuleSets.BaseRuleSet );

			//Removed BR_77.01 states it should be previous day - which is set in base object VbecsReport
			//StartDate = EndDate = VBECSDateTime.GetDivisionCurrentDateTime();

			IsDirty = false;
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5846"> 
		///		<ExpectedInput>Valid date range and division code.</ExpectedInput>
		///		<ExpectedOutput>
		///			Non-null result - DataTable; no exception is thrown. It is not feasible to predict how many 
		///			records will the report return without fully replicating it in unit tests. It is not also 
		///			practically possible to set up a unit test that will create set of data providing deterministic result.
		///		</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5848"> 
		///		<ExpectedInput>Start date is after end date.</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generates and returns data for the inappropriate transfusion request report.
		/// </summary>
		/// <returns><see cref="DataTable"/> containing data for the report.</returns>
		public virtual DataSet GetReportData()
		{
			VerifyObjectValidityBeforeGeneratingReport();

			return DAL.InappropriateTransfusionRequestReport.GetReportData( this.StartDate, this.EndDate );
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6747"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6748"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generates and prints report. Used by VbecsConsoleReport application.
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            _dsReport = this.GetReportData();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.GetReportCriteriaText());

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateTransfusionRequestReport.rdlc");
            Stream streamSurgical = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateSurgicalRequests.rdlc");
            Stream streamNonSurgical = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateNonSurgicalRequests.rdlc");
            Stream streamDivTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.DivisionTestingThresholds.rdlc");
            Stream streamDivMsbos = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.DivisionMsbosRecommendations.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("InappropriateSurgicalRequests", streamSurgical);
            report.LoadSubreportDefinition("InappropriateNonSurgicalRequests", streamNonSurgical);
            report.LoadSubreportDefinition("DivisionTestingThresholds", streamDivTesting);
            report.LoadSubreportDefinition("DivisionMsbosRecommendations", streamDivMsbos);

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName].Rows.Count == 0)
                report.SetParameters(new ReportParameter("HideSurgical", "true"));
            else
                report.SetParameters(new ReportParameter("HideSurgical", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName].Rows.Count == 0)
                report.SetParameters(new ReportParameter("HideNonSurgical", "true"));
            else
                report.SetParameters(new ReportParameter("HideNonSurgical", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName].Rows.Count == 0)
                report.SetParameters(new ReportParameter("HideDivTesting", "true"));
            else
                report.SetParameters(new ReportParameter("HideDivTesting", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName].Rows.Count == 0)
                report.SetParameters(new ReportParameter("HideDivMsbos", "true"));
            else
                report.SetParameters(new ReportParameter("HideDivMsbos", "false"));

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "InappropriateSurgicalRequests" || e.DataSourceNames[0].ToString() == "InappropriateSurgicalRequestsDataSet")
            {
                ReportDataSource reportSourceSurgical = new ReportDataSource();
                reportSourceSurgical.Name = "InappropriateSurgicalRequestsDataSet";
                reportSourceSurgical.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName];
                e.DataSources.Add(reportSourceSurgical);
            }
            else if (e.ReportPath == "InappropriateNonSurgicalRequests" || e.DataSourceNames[0].ToString() == "InappropriateNonSurgicalRequestsDataSet")
            {
                ReportDataSource reportSourceNonSurgical = new ReportDataSource();
                reportSourceNonSurgical.Name = "InappropriateNonSurgicalRequestsDataSet";
                reportSourceNonSurgical.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName];
                e.DataSources.Add(reportSourceNonSurgical);
            }
            else if (e.ReportPath == "DivisionTestingThresholds" || e.DataSourceNames[0].ToString() == "DivisionTestingThresholdDataSet")
            {
                ReportDataSource reportSourceDivisionTesting = new ReportDataSource();
                reportSourceDivisionTesting.Name = "DivisionTestingThresholdDataSet";
                reportSourceDivisionTesting.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName];
                e.DataSources.Add(reportSourceDivisionTesting);
            }
            else if (e.ReportPath == "DivisionMsbosRecommendations" || e.DataSourceNames[0].ToString() == "DivisionMsbosRecommendationsDataSet")
            {
                ReportDataSource reportSourceDivisionMsbosRecommendations = new ReportDataSource();
                reportSourceDivisionMsbosRecommendations.Name = "DivisionMsbosRecommendationsDataSet";
                reportSourceDivisionMsbosRecommendations.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName];
                e.DataSources.Add(reportSourceDivisionMsbosRecommendations);
            }
        }

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6313"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6314"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets report criteria text to be added to report output.
		/// </summary>
		/// <returns>Human-readable text describing report criteria. </returns>
		public virtual string GetReportCriteriaText()
		{
			return GetDateRangeReportCriteria();
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/28/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6763"> 
		///		<ExpectedInput>Valid start end and end dates, division code. </ExpectedInput>
		///		<ExpectedOutput>Non-negative integer.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6765"> 
		///		<ExpectedInput>Invalid date range (start date is after the end date).</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves record count estimate (the number is exact, but it can change 
		/// before <see cref="GetReportData"/> will be invoked) for the report.
		/// </summary>
		/// <returns>Record count estimate.</returns>
		public virtual int GetRecordCountEstimate()
		{
			VerifyObjectValidityBeforeGeneratingReport();

			return DAL.InappropriateTransfusionRequestReport.GetRecordCountEstimate( this.StartDate, this.EndDate );
		}

		/// <summary>
		/// Verifies that object is in valid state and throws exception if it's invalid.
		/// </summary>
		protected virtual void VerifyObjectValidityBeforeGeneratingReport()
		{
			//If its scheduled, by the time it prints, the print date might be in the past - which violates the rules
			//so we'll only do this check when not scheduling
			if (this.IsScheduled)
				return;

			if( !this.IsValid )
				throw( new BusinessObjectException( StrRes.SysErrMsg.Common.UnableToGenerateReportBecauseSomeRulesAreBroken( this.BrokenRulesCount, this.GetType().Name ).ResString ) );
		}
	}
}
